/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.data;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import net.ftb.data.Settings;
import net.ftb.log.Logger;
import net.ftb.util.OSUtils;

public class LauncherStyle
extends Properties {
    private static final long serialVersionUID = 6370446700503387209L;
    private static LauncherStyle currentStyle;
    private static File baseStylePath;
    public Color control = new Color(40, 40, 40);
    public Color text = new Color(40, 40, 40).brighter().brighter().brighter().brighter().brighter();
    public Color nimbusBase = new Color(0, 0, 0);
    public Color nimbusFocus = new Color(40, 40, 40);
    public Color nimbusBorder = new Color(40, 40, 40);
    public Color nimbusLightBackground = new Color(40, 40, 40);
    public Color info = new Color(40, 40, 40).brighter().brighter();
    public Color nimbusSelectionBackground = new Color(40, 40, 40).brighter().brighter();
    public Color footerColor = new Color(25, 25, 25);
    public Color filterTextColor = new Color(243, 119, 31);
    public Color filterInnerTextColor = new Color(255, 255, 255);
    public Color tabPaneBackground = new Color(255, 255, 255, 0);
    public Color tabPaneForeground = new Color(255, 255, 255);
    public Color headerImageColor = new Color(255, 255, 255);
    public Color headerColor = new Color(243, 119, 31);
    public Color headerImageHighlightColor = new Color(236, 26, 61);
    public Color headerHighlightColor = new Color(236, 26, 61);

    public void load() {
        this.load(Settings.getSettings().getStyle());
    }

    public void load(String file) {
        File filename = new File(baseStylePath, file);
        if (new File(baseStylePath, file).exists()) {
            try {
                this.load(new FileReader(filename));
            }
            catch (FileNotFoundException e) {
                Logger.logWarn("Could not load style", e);
            }
            catch (IOException e) {
                Logger.logWarn("Could not load style", e);
            }
        }
        this.control = this.loadColor("control", this.control);
        this.text = this.loadColor("text", this.text);
        this.nimbusBase = this.loadColor("nimbusBase", this.nimbusBase);
        this.nimbusFocus = this.loadColor("nimbusFocus", this.nimbusFocus);
        this.nimbusBorder = this.loadColor("nimbusBorder", this.nimbusBorder);
        this.nimbusLightBackground = this.loadColor("nimbusLightBackground", this.nimbusLightBackground);
        this.info = this.loadColor("info", this.info);
        this.nimbusSelectionBackground = this.loadColor("nimbusSelectionBackground", this.nimbusSelectionBackground);
        this.footerColor = this.loadColor("footerColor", this.footerColor);
        this.filterTextColor = this.loadColor("filterTextColor", this.filterTextColor);
        this.filterInnerTextColor = this.loadColor("filterInnerTextColor", this.filterInnerTextColor);
        try {
            this.store(new FileOutputStream(filename), "FTB Style File");
        }
        catch (FileNotFoundException e) {
            Logger.logWarn("Could not save style", e);
        }
        catch (IOException e) {
            Logger.logWarn("Could not save style", e);
        }
    }

    public static String getColorAsString(Color col) {
        return col.getRed() + "," + col.getGreen() + "," + col.getBlue();
    }

    public static Color getStringAsColor(String str) {
        String[] tokens = str.split(",");
        return new Color(Integer.parseInt(tokens[0]), Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]));
    }

    private Color loadColor(String string, Color defaultColor) {
        String defaultColorStr = LauncherStyle.getColorAsString(defaultColor);
        if (!this.containsKey(string)) {
            this.setProperty(string, defaultColorStr);
        }
        return LauncherStyle.getStringAsColor(this.getProperty(string, defaultColorStr));
    }

    public static LauncherStyle getCurrentStyle() {
        return currentStyle;
    }

    public static void setCurrentStyle(LauncherStyle currentStyle) {
        LauncherStyle.currentStyle = currentStyle;
    }

    public ImageIcon filterHeaderIcon(URL u) {
        try {
            return this.changeColor(ImageIO.read(u), this.headerImageColor, this.headerColor, this.headerImageHighlightColor, this.headerHighlightColor);
        }
        catch (Exception e) {
            Logger.logWarn("error changing colors, using default instead");
            return new ImageIcon(u);
        }
    }

    public ImageIcon changeColor(BufferedImage image, Color toReplace, Color newColor, Color toReplace2, Color newColor2) {
        BufferedImage destImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g = destImage.createGraphics();
        g.drawImage(image, null, 0, 0);
        g.dispose();
        for (int i = 0; i < destImage.getWidth(); ++i) {
            for (int j = 0; j < destImage.getHeight(); ++j) {
                Color c = new Color(image.getRGB(i, j), true);
                if (toReplace != null && this.compareColors(toReplace, c)) {
                    destImage.setRGB(i, j, this.getRGB(newColor, c));
                }
                if (toReplace2 == null || !this.compareColors(toReplace2, c)) continue;
                destImage.setRGB(i, j, this.getRGB(newColor2, c));
            }
        }
        return new ImageIcon(destImage);
    }

    public boolean compareColors(Color b, Color c) {
        return c.getBlue() == b.getBlue() && c.getRed() == b.getRed() && c.getGreen() == b.getGreen();
    }

    public int getRGB(Color nw, Color oldColorWithTrans) {
        return new Color(nw.getRed(), nw.getGreen(), nw.getBlue(), oldColorWithTrans.getAlpha()).getRGB();
    }

    static {
        baseStylePath = new File(OSUtils.getDynamicStorageLocation(), "launcher_styles");
        if (!baseStylePath.exists()) {
            baseStylePath.mkdir();
        }
        currentStyle = new LauncherStyle();
        currentStyle.load();
    }
}

